﻿                                                                                #--------------gestion des erreurs--------------
                                                                                $error.clear()
                                                                                $ErrorActionPreference='continue'


$TT1=[System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Definition)
$C_INI=$TT1+"\maj.ini"

$L_ini=Get-Content $C_INI 

$ini=[ordered]@{}

foreach ($V_INI in $L_INI)
{

if ( $V_INI.Contains("###") -eq $False )


    {

    $a =$V_INI.split("=")

                if ($a[0] -ne "")
                {
                                  
                $ini.Add($a[0],$a[1])
                       
                }
    }
}

#-------lancement du fichier install------

if ( $ini.DESTINATION_NAS_VEEAM -eq $null)
{
write-host "ok"

$fichierInstall=$TT1+"\INSTALL.PS1"

Start-Process -FilePath "C:\Windows\System32\WindowsPowerShell\v1.0\powershell.exe" -ArgumentList $fichierInstall

}




$DateLog=get-date

$jour=$DateLog.DayOfWeek

if ($jour -eq "Monday")
{
$JourLog = "LUNDI"
}
elseif ($jour -eq "Tuesday")
{
$JourLog = "MARDI"
}
elseif ($jour -eq "Wednesday")
{
$JourLog = "MERCREDI"
}
elseif ($jour -eq "Thursday")
{
$JourLog = "JEUDI"
}
elseif ($jour -eq "Friday")
{
$JourLog = "VENDREDI"
}
elseif ($jour -eq "Saturday")
{
$JourLog = "SAMEDI"
}
elseif ($jour -eq "Sunday")
{
$JourLog = "DIMANCHE"
}

$CheminDossierLog=$TT1+"\LOG\"

if (Test-Path $CheminDossierLog)
{



       $chemin_fichierlog=$TT1+"\LOG\"+"BCKZIP_"+$JourLog+".txt"

       New-Item -path $chemin_fichierlog -ItemType file -Force

       Add-Content -Path $chemin_fichierlog -Value $DateLog

}
else 
{

       New-Item -Path $CheminDossierLog -ItemType Directory

       $chemin_fichierlog=$TT1+"\LOG\"+$JourLog+"_BCKZIP"+".txt"

       New-Item -path $chemin_fichierlog -ItemType file -Force

       Add-Content -Path $chemin_fichierlog -Value $DateLog

}

#----------------------Function INFO_MAJ_INI-----------------------------#

function INFO_MAJ_INI
{

$ContenuTxt="ENTREPRISE="+$INI.ENTREPRISE
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

$ContenuTxt="SERVEUR="+$PCServeur
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

$ContenuTxt="Dernier_Reboot="+$Der_Reboot.lastbootuptime
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

$ContenuTxt="OE="+$INI.OE
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

$ContenuTxt="BASE="+$INI.BASE
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

$ContenuTxt="BASE2="+$INI.BASE2
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

$ContenuTxt="BASE3="+$INI.BASE3
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

$ContenuTxt="BASE4="+$INI.BASE4
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

$ContenuTxt="NAS="+$INI.NAS
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

     if ([string]::IsNullOrEmpty($INI.NAS))
        {
        $ContenuTxt="NAS_ACCEES=CHAINE_VIDE"
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        }
        else 
        {
            if (Test-Path $INI.NAS)
            {
            $ContenuTxt="NAS_ACCEES=OK"
            Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
            }
            else
            {
            $ContenuTxt="NAS_ACCEES=PAS_ACCES"
            Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
            }
        } 
  
$ContenuTxt="LDSYSTEME="+$INI.LDSYSTEME
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt  

$ContenuTxt="NAS_LDSYSTEME="+$INI.NAS_LDSYSTEME
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt  

$Test_Dossier_COMPTA_CLient= Test-Path $ini.REP_CLIENT

if ( $Test_Dossier_COMPTA_CLient -eq $true)
{
$ContenuTxt="QUADRA=ACTIVE"
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

}
else 
{
$ContenuTxt="QUADRA=PAS ACTIVE"
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

}




    

   


}

#-----------Function  BCK sur le NAS Verfication_BCK_NAS----------------#

Function Verfication_BCK_NAS
 {
[INT]$i='0'
 $BCKJOUR=Get-ChildItem $cheminBCKZIP | where-Object {$_.Mode -eq "-a----"}

     for ($i ='0';$i-lt  $BCKJOUR.Count;$i++)
     {

            if ($BCKJOUR[$i].Mode -eq "-a----")
         {
       $NOMBCKNAS=$BCKJOUR[$i].Name #récuperation du nom du fichier $BCKJOUR=Get-ChildItem $CHEMIN_BCK

     $ContenuTxt="BCKNAS_"+$JOUR_NAS_BCK+"_Fichier"+$i+"_NOM="+$NOMBCKNAS

     Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

     $TAILLEBCKNAS=format-fileSize($BCKJOUR[$i].Length) #envoi function format-fileSize

     $ContenuTxt="BCKNAS_"+$JOUR_NAS_BCK+"_Fichier"+$i+"_TAILLE="+$TAILLEBCKNAS

     Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

     $contenudate=$BCKJOUR[$i].LastWriteTime.date #recuperation date
     $contenudate=$contenudate.ToString("yyyy/MM/dd") #mise en forme string

     $ContenuTxt="BCKNAS_"+$JOUR_NAS_BCK+"_Fichier"+$i+"_DATE="+$contenudate

     Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
       }
     }
}

#----------------------Function TELECHARGER-----------------------------#

function FTPTelecharger 
{

       $FTPRequest = [System.Net.FtpWebRequest]::Create($RemoteFile)
       $FTPRequest.Credentials = New-Object System.Net.NetworkCredential($Username, $PasswordFTP)
       $FTPRequest.Method = [System.Net.WebRequestMethods+Ftp]::DownloadFile
       $FTPRequest.UseBinary = $true
       $FTPRequest.KeepAlive = $false
   
       $FTPResponse = $FTPRequest.GetResponse()
       write-host "FTPResponse: " $FTPResponse 
   
       $ResponseStream = $FTPResponse.GetResponseStream()
       write-host "ResponseStream : "$ResponseStream
   
       $LocalFileFile = New-Object IO.FileStream ($LocalFile, [IO.FileMode]::Create)
   
   
       Write-Host "LocalFileFile  ; "$LocalFileFile 
       [byte[]]$ReadBuffer = New-Object byte[] 1024
   
   
       do {
           $ReadLength = $ResponseStream.Read($ReadBuffer, 0, 1024)
           Write-Host "readlength : " $readlength
           $LocalFileFile.Write($ReadBuffer, 0, $ReadLength)
           if ($NULL -eq $ReadLength ) { break }
       }
       while ($ReadLength -ne 0)
   
       
       
       $LocalFileFile.Close()
}


#--------------------------Function UPLOAD-----------------------------#
function FTP_UPLOAD
{
# Create FTP Rquest Object
$FTPRequest = [System.Net.FtpWebRequest]::Create("$RemoteFile")
$FTPRequest = [System.Net.FtpWebRequest]$FTPRequest
$FTPRequest.Method = [System.Net.WebRequestMethods+Ftp]::UploadFile
$FTPRequest.Credentials = new-object System.Net.NetworkCredential($Username, $PasswordFTP)
LOG -V1 "Username FTP : " -LOG -V2 $Username
$FTPRequest.UseBinary = $true
$FTPRequest.UsePassive = $true
# Read the File for Upload
$FileContent = gc -en byte $LocalFile
$FTPRequest.ContentLength = $FileContent.Length
# Get Stream Request by bytes
$Run = $FTPRequest.GetRequestStream()
$Run.Write($FileContent, 0, $FileContent.Length)
# Cleanup
$Run.Close()
$Run.Dispose()

LOG -V1 " fin upload"
write-host " fin upload"
}
 
 #--------------------------Function ENVOI MAIL------------------------#
   
function EnvoiMail
{
    

 [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
 $password_mail="ndlbpmlzkllpvhvg"
 $credentials = New-Object System.Net.NetworkCredential($ini.EMAIL_ENVOI,$Password_mail);
 $message = New-Object System.Net.Mail.MailMessage $ini.EMAIL_ENVOI,$ini.EMAIL_DESTINATAIRE, $objet, $body
 $smtpClient = New-Object System.Net.Mail.SmtpClient $ini.SMTPServer, 587
 $smtpClient.EnableSsl = $true
 $smtpClient.Timeout = 100000
 $smtpClient.UseDefaultCredentials = $false;
 $smtpClient.Credentials = $credentials

 write-host "ini.EMAIL_ENVOI : "$ini.EMAIL_ENVOI
 write-host "ini.EMAIL_DESTINATAIRE :"$ini.EMAIL_DESTINATAIRE
 write-host "ini.SMTPServer :" $ini.SMTPServer
 write-host "objet :" $objet 
 write-host "body : "$body
 write-host

 log -V1 ""
 log -V1 "---------parametre Email OFFICE 365----------"
 log -V1 "ini.EMAIL_ENVOI : " -V2 $ini.EMAIL_ENVOI
 log -V1 "ini.EMAIL_DESTINATAIRE : " -V2 $ini.EMAIL_DESTINATAIRE
 log -V1 "ini.SMTPServer : " -V2 $ini.SMTPServer
 log -V1 "objet : " -V2 $objet
 log -V1 "body : " -V2 $body

  $smtpClient.Send($message)

   if ($? -eq $false  )
  {
  
  log -v1 ""           
  log -v1 "---------------------Erreur OFFICE envoi mail via orange------------------------"
  write-host " Gestion des erreur ? :  "$?
    
  log -v1 " Gestion des erreur ? : " -v2 $?
  log -v1 ""
  log -V1 "body et objet avant l'envoi dans la fonction EnvoiMailorange "
  log -V1 "objet : " -V2 $objet 
  log -V1 "body : " -V2 $body
  log -V1 ""  
  write-host "------------------Erreur OFFICE envoi mail via orange----------------------------"
  EnvoiMailorange
  }
}

 #--------------------------Function ENVOI MAIL PIECE JOINTE------------------------#
function EnvoiMailPieceJointe
{
 [Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
 $password_mail="ndlbpmlzkllpvhvg"
 $att = new-object System.Net.Mail.Attachment $chemin_FichierJoint
 $credentials = New-Object System.Net.NetworkCredential($ini.EMAIL_ENVOI,$Password_mail);
 $message = New-Object System.Net.Mail.MailMessage $ini.EMAIL_ENVOI,$ini.EMAIL_DESTINATAIRE, $objet, $body
 $smtpClient = New-Object System.Net.Mail.SmtpClient $ini.SMTPServer, 587
 $smtpClient.EnableSsl = $true
 $smtpClient.Timeout = 100000
 $smtpClient.UseDefaultCredentials = $false;
 $smtpClient.Credentials = $credentials
 $message.Attachments.Add($att)

 write-host "ini.EMAIL_ENVOI : "$ini.EMAIL_ENVOI
 write-host "ini.EMAIL_DESTINATAIRE :"$ini.EMAIL_DESTINATAIRE
 write-host "ini.SMTPServer :" $ini.SMTPServer
 write-host "objet :" $objet 
 write-host "body : "$body
 write-host

 log -V1 ""
 log -V1 "---------parametre Email OFFICE 365----------"
 log -V1 "ini.EMAIL_ENVOI : " -V2 $ini.EMAIL_ENVOI
 log -V1 "ini.EMAIL_DESTINATAIRE : " -V2 $ini.EMAIL_DESTINATAIRE
 log -V1 "ini.SMTPServer : " -V2 $ini.SMTPServer
 log -V1 "objet : " -V2 $objet
 log -V1 "body : " -V2 $body

  $smtpClient.Send($message)

       if ($? -eq $false  )
       {
       
       log -v1 ""           
       log -v1 "---------------------Erreur OFFICE envoi mail via orange------------------------"
       write-host " Gestion des erreur ? :  "$?
       
       log -v1 " Gestion des erreur ? : " -v2 $?
       log -v1 ""
       log -V1 "body et objet avant l'envoi dans la fonction EnvoiMailorange "
       log -V1 "objet : " -V2 $objet 
       log -V1 "body : " -V2 $body
       log -V1 ""  
       write-host "------------------Erreur OFFICE envoi mail via orange----------------------------"
       EnvoiMailorangePieceJointe
       }

       $body=""
       $objet=""
       Start-Sleep -Seconds 2 
}

 #--------------------------Function ENVOI MAIL ORANGE------------------------#
function EnvoiMailorange
{
    
 $credentials = New-Object System.Net.NetworkCredential($ini.MAIL_ORANGE,$Password_mail_orange);
 $message = New-Object System.Net.Mail.MailMessage $ini.MAIL_ORANGE,$ini.EMAIL_DESTINATAIRE, $objet, $body
 $smtpClient = New-Object System.Net.Mail.SmtpClient $ini.SMTP_ORANGE, 587
 $smtpClient.EnableSsl = $false
 $smtpClient.Timeout = 100000
 $smtpClient.UseDefaultCredentials = $false;
 $smtpClient.Credentials = $credentials
 write-host ""
 write-host "ini.EMAIL_ENVOI : "$ini.MAIL_ORANGE
 write-host "ini.EMAIL_DESTINATAIRE :"$ini.EMAIL_DESTINATAIRE
 write-host "ini.SMTPServer :" $ini.SMTP_ORANGE
 write-host "objet :" $objet 
 write-host "body : "$body
 write-host
 
 log -V1 ""
 log -v1 "---------parametre Email ORANGE---------"
 log -V1 "ini.MAIL_ORANGE : " -V2 $ini.MAIL_ORANGE
 log -v1 "ini.EMAIL_DESTINATAIRE : " -v2 $ini.EMAIL_DESTINATAIRE
 log -V1 "ini.SMTP_ORANGE : " -V2 $ini.SMTP_ORANGE
 log -V1 "objet : " -V2 $objet
 log -V1 "body : " -V2 $body
 

  $smtpClient.Send($message)

       $body=""
       $objet=""
       Start-Sleep -Seconds 2 
}


 #--------------------------Function ENVOI MAIL ORANGE PIECE JOINTE------------------------#
function EnvoiMailorangePieceJointe
{
    

 $att = new-object System.Net.Mail.Attachment $chemin_FichierJoint
 $credentials = New-Object System.Net.NetworkCredential($ini.EMAIL_ENVOI,$Password_mail);
 $message = New-Object System.Net.Mail.MailMessage $ini.EMAIL_ENVOI,$ini.EMAIL_DESTINATAIRE, $objet, $body
 $smtpClient = New-Object System.Net.Mail.SmtpClient $ini.SMTPServer, 587
 $smtpClient.EnableSsl = $true
 $smtpClient.Timeout = 100000
 $smtpClient.UseDefaultCredentials = $false;
 $smtpClient.Credentials = $credentials
 $message.Attachments.Add($att)

 write-host "ini.EMAIL_ENVOI : "$ini.EMAIL_ENVOI
 write-host "ini.EMAIL_DESTINATAIRE :"$ini.EMAIL_DESTINATAIRE
 write-host "ini.SMTPServer :" $ini.SMTPServer
 write-host "objet :" $objet 
 write-host "body : "$body
 write-host

 log -V1 ""
 log -V1 "---------parametre Email OFFICE 365----------"
 log -V1 "ini.EMAIL_ENVOI : " -V2 $ini.EMAIL_ENVOI
 log -V1 "ini.EMAIL_DESTINATAIRE : " -V2 $ini.EMAIL_DESTINATAIRE
 log -V1 "ini.SMTPServer : " -V2 $ini.SMTPServer
 log -V1 "objet : " -V2 $objet
 log -V1 "body : " -V2 $body

  $smtpClient.Send($message)

 

       $body=""
       $objet=""
       Start-Sleep -Seconds 2 
}


 #--------------------------Function FILESIZE------------------------#
Function Format-FileSize() 
{
       Param ([long]$size)
       If ($size -gt 1TB) {[string]::Format("{0:0.00} TB", $size / 1TB)}
       ElseIf ($size -gt 1GB) {[string]::Format("{0:0.00} GB", $size / 1GB)}
       ElseIf ($size -gt 1MB) {[string]::Format("{0:0.00} MB", $size / 1MB)}
       ElseIf ($size -gt 1KB) {[string]::Format("{0:0.00} kB", $size / 1KB)}
       ElseIf ($size -gt 0) {[string]::Format("{0:0.00} B", $size)}
       Else {""}
}


 #--------------------------Function LOG -------------------------#
Function log
{
       param
       (
       [STRING]$V1,
       [STRING]$V2,
       [STRING]$V3

       )
       $Ajout_Log=$V1+$V2+$V3
       Add-Content -Path $chemin_fichierlog -Value $Ajout_Log

}

#--------------------------Function SAUVEGARDE -------------------------#

Function Sauvegarde
{


        log -V1 ""        
        log -V1 "------------------------Variable pour le BCK et le ZIP---------------------------"
        log -V1 "fichierBCK : " -V2 $fichierBCK
        log -V1 "fichierzip : " -V2 $fichierzip

        write-host "bck "$fichierBCK

        log -V1 ""
        log -v1 "---------------------------------------BCK---------------------------------------"
        log -V1 "heure Départ BCK"

        $heure = get-date

        log -V1 $heure                                                            
        log -V1 "F_BCK :" -v2 $F_BCK

 $RapportBCK=Invoke-Expression $F_BCK #---creation BCK
 Start-Sleep -Seconds 5 

        log -V1 $RapportBCK

        
        $info_fichierbck = Get-ChildItem $fichierBCK #---info
        Write-Host "info_fichierbck :"$info_fichierbck -ForegroundColor Yellow
        $date_fichierbck=$info_fichierbck.LastWriteTime #---date         
        Write-Host "date_fichierbck : "$date_fichierbck -ForegroundColor Yellow
        $Taille_BCK=$info_fichierbck.Length #---taille
       
               log -V1 ""               
               Log -v1 "---------------------------INFO Sur Fichier BCK----------------------------------"
               Log -V1 "info_fichierbck"
               Log -V1 $info_fichierbck
               Log -V1 "info date dernier écriture Fichier BCK "
               Log -V1 $date_fichierbck
               Log -V1 "Info Taille Fichier Bck"
               Log -V1 $Taille_BCK

        log -V1 ""        
        log -v1 "-------------------------------------ZIP-----------------------------------------"
        log -V1 "heure Départ ZIP"
        
        
        $heure =get-date

        log -V1 $heure                                                       
        log -V1 "F_ZIP :" -V2 $F_ZIP

 $RapportZIP=Invoke-Expression $F_ZIP 
                                                            
        log -v1 $RapportZIP

        log -V1 ""
        log -v1 "-------------------------------taille fichier bck---------------------------------"

         $size=""
         $size=Format-FileSize((Get-Item $fichierBCK).length)
         $sizebck=$size

        Write-Host($sizebck)
        log -V1 $sizebck

        log -V1 ""
        log -V1 "-------------------------------taille fichier ZIP--------------------------------"

         $size=Format-FileSize((Get-Item $fichierzip).length)
         $sizezip=$size

        Write-Host($sizezip)
        log -V1 $sizezip

        $info_fichierzip = Get-ChildItem $fichierzip
        $date_fichierzip=$info_fichierzip.LastWriteTime.date
        $Taille_ZIP=$info=$info_fichierZIP.Length
       
       log -V1 ""        
       Log -v1 "--------------------------INFO Sur Fichier ZIP-----------------------------------"
       Log -V1 "info_fichier ZIP"
       Log -V1 $info_fichierzip
       Log -V1 "info date dernier écriture Fichier ZIP "
       Log -V1 $date_fichierzip
       Log -V1 "Info Taille Fichier ZIP"
       Log -V1 $Taille_ZIP=$info


                                        #---Variable pour la copie Ficier ZIP
         $SOURCE=$fichierzip                         #---Source ZIP
         $DESTINATION="'"+$ini.NAS+"BCK\"+$JourLog+"\"+"'"   #Destination ZIP  

        log -V1 ""
        log -V1 "------------------------Variable pour la copie Fichier zip-----------------------"
        log -v1 "SOURCE      : " -V2 $SOURCE
        log -V1 "DESTINATION : " -V2 $DESTINATION
        log -V1 ""
        log -V1 "---------------------Test Accés Dossier BCK\JOURS Sur le  NAS--------------------"


                                       #---Verification dossier de destination pour le ZIP
        $TestNAS = Test-Path $DESTINATION

        log -V1 $TestNAS 

         if ($TestNAS -eq $False)
         {
                New-Item -Path $DESTINATION -ItemType Directory
                log -V1 ""
                log -V1 "---------------------Creation Du Dossier BCK\JOURS sur le NAS-------------------"

                $TestNAS = Test-Path $DESTINATION ### refait un test du fichier de destination
                log -V1 $TestNAS
         }
                                                           
        log -V1 ""
        log -V1 "------------------------Copie du Fichier ZIP Sur le  NAS------------------------"
        write-host "SOURCE      : " $SOURCE
        write-host "DESTINATION : "$DESTINATION

        Log -V1 "SOURCE      : " -V2 $SOURCE
        Log -V1 "DESTINATION : " -V2 $DESTINATION

    

     $copyNAsZIP="xcopy "+$SOURCE+" "+$DESTINATION+" /C /R /H /I /K /Y /D"


     $RapportcopyNasZIP=Invoke-Expression $copyNasZIP

 $global:body
 $global:objet
        
        #----gestion des erreurs ecriture dans log et dans le fichier TXT-------------
        if ($? -eq $false -or $LASTEXITCODE -ne "0" )
        {
        write-host " ? ! "$?
        write-host  "error : "$error
        write-host "lastexitcode : "$LASTEXITCODE
        log -v1 " ? ! " -v2 $?
        log -v1 "error : " -v2 $error
        log -v1 "lastexitcode : " -v2 $LASTEXITCODE
        
        $body="Erreur copie ZIP vers NAS : "+$SOURCE+"     Destination : "+$DESTINATION

        $objet="!-TECHNIQUE-! BCKZIP : Erreur copie ZIP vers NAS : "+ $ini.ENTREPRISE
        EnvoiMail
         
        switch ($switchbase)
            {
                base1{ $basePourZIP="BASE1"}
                base2{ $basePourZIP="BASE2"}
                base3{ $basePourZIP="BASE3"}
                base4{ $basePourZIP="BASE4"}


            }
         $ContenuTxt="ZIP"+$basePourZIP+"_COPIE_NAS=ERREUR_COPIE_ZIP_VERS_NAS"
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="ZIP_"+$basePourZIP+"_SOURCE="+$SOURCE
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="ZIP_"+$basePourZIP+"_DESTINATION="+$DESTINATION
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

        $error.clear()
        }
        else
        {
            if ($ini.Copie_ZIP_VERS_NAS -ne "NON")
            {
              log -V1 ""
              log -V1 $RapportCopyNasZIP

                switch ($switchbase)
            {
                base1{ $basePourZIP="BASE1"}
                base2{ $basePourZIP="BASE2"}
                base3{ $basePourZIP="BASE3"}
                base4{ $basePourZIP="BASE4"}


            }

         $ContenuTxt="ZIP_"+$basePourZIP+"_COPIE_NAS=OK"
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="ZIP_"+$basePourZIP+"_SOURCE="+$SOURCE
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="ZIP_"+$basePourZIP+"_DESTINATION="+$DESTINATION
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt                                                  
            } 
        }
        
              
       
 

       
   


 $date_ecartZIP=$date_du_jour.date-$date_fichierzip

 $date_ecartBCK=$date_du_jour.date-$date_fichierbck





     if ($date_ecartBCK.Days -gt 2 -or (Test-Path $fichierBCK) -eq $FALSE -or $info_fichierbck.Length -eq "0" )
     {
         $body=$fichierBCK+"     Date Supérieure à 2jours ou fichier manquant ou taille à zero" 
         $objet="ECHEC_BCK_ : BCKZIP :"+$ini.ENTREPRISE
         EnvoiMail       
       switch ($switchbase)
            {
                base1{ $basePourBCKTAILLEDATE="BASE1"}
                base2{ $basePourBCKTAILLEDATE="BASE2"}
                base3{ $basePourBCKTAILLEDATE="BASE3"}
                base4{ $basePourBCKTAILLEDATE="BASE4"}


            }
         $ContenuTxt="BCK_"+$basePourBCKTAILLEDATE+"=GENERATION_BCK_OFF"
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="BCK_"+$basePourBCKTAILLEDATE+"_TAILLE="+$sizebck
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $BCK_ZIP_TXT=$date_fichierbck.ToString("yyyy/MM/dd")
         $ContenuTxt="BCK_"+$basePourBCKTAILLEDATE+"_DATE="+$BCK_ZIP_TXT
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
     }
     else
     {
        $body=@"
        $fichierBCK OK 
        taille : $sizebck
"@
        $objet="SUCCES_BCK_ : BCKZIP :"+$ini.ENTREPRISE 
        EnvoiMail
         switch ($switchbase)
            {
                base1{ $basePourBCKTAILLEDATE="BASE1"}
                base2{ $basePourBCKTAILLEDATE="BASE2"}
                base3{ $basePourBCKTAILLEDATE="BASE3"}
                base4{ $basePourBCKTAILLEDATE="BASE4"}


            }
        $ContenuTxt="BCK_"+$basePourBCKTAILLEDATE+"=GENERATION_BCK_OK"
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="BCK_"+$basePourBCKTAILLEDATE+"_TAILLE="+$sizebck
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt 
        $BCK_ZIP_TXT=$date_fichierbck.ToString("yyyy/MM/dd")
        $ContenuTxt="BCK_"+$basePourBCKTAILLEDATE+"_DATE="+$BCK_ZIP_TXT
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
     }

         if ($date_ecartZIP.Days -gt 2 -or (Test-Path $fichierZIP) -eq $FALSE -or $info_fichierZIP.Length -eq "0")
         {
            $body=$fichierZIP+"      Date Supérieure à 2jours ou fichier manquant ou taille à zero" 
            $objet="ECHEC_ZIP_ : BCKZIP : "+$ini.ENTREPRISE
            EnvoiMail
             switch ($switchbase)
            {
                base1{ $basePourZIPTAILLEDATE="BASE1"}
                base2{ $basePourZIPTAILLEDATE="BASE2"}
                base3{ $basePourZIPTAILLEDATE="BASE3"}
                base4{ $basePourZIPTAILLEDATE="BASE4"}


            }
             $ContenuTxt="ZIP_"+$basePourZIPTAILLEDATE+"_ERREUR=Date Supérieure à 2jours ou fichier manquant ou taille à zero"
             Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
             $ContenuTxt="ZIP_"+$basePourZIPTAILLEDATE+"_TAILLE="+$sizezip
             Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt 
              $BCK_ZIP_TXT=$date_fichierzip.ToString("yyyy/MM/dd")
             $ContenuTxt="ZIP"+$basePourZIPTAILLEDATE+"_DATE="+$BCK_ZIP_TXT
            Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt 
         }
         else
         {

            $body=@"
            $fichierZIP OK
            taille : $sizezip
"@

            $objet="SUCCES_ZIP_ : BCKZIP :"+$ini.ENTREPRISE
            EnvoiMail

              switch ($switchbase)
            {
                base1{ $basePourZIPTAILLEDATE="BASE1"}
                base2{ $basePourZIPTAILLEDATE="BASE2"}
                base3{ $basePourZIPTAILLEDATE="BASE3"}
                base4{ $basePourZIPTAILLEDATE="BASE4"}


            }
             $ContenuTxt="ZIP-"+$basePourZIPTAILLEDATE+"_TAILLE="+$sizezip
             Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt 
             $BCK_ZIP_TXT=$date_fichierzip.ToString("yyyy/MM/dd")
             $ContenuTxt="ZIP_"+$basePourZIPTAILLEDATE+"_DATE="+$BCK_ZIP_TXT
            Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         }
 } 
 
#-------------------------------SPECIF ST-------------------------"
 function ST
 {
     $SOURCE=$fichierst
 $DESTINATION="'"+$ini.NAS+"ST\"+"'"
        log -v1 ""
        log -v1 "---------------------------VARIABLE Fichier ST----------------------------------"
        log -V1 "SOURCE      : " -V2 $SOURCE
        log -v1 "DESTINATION : " -v2 $DESTINATION
        log -V1 ""
        log -V1 "----------------------Test Accés Dossier ST Sur le  NAS-------------------------"   

     if ($ini.Copie_ZIP_VERS_NAS -eq "OUI")
     {
        $TestNAS = Test-Path $DESTINATION

        log -V1 $TestNAS                                                            
        if ($TestNAS -eq $False) 
        {
        New-Item -Path $DESTINATION -ItemType Directory

            log -V1 ""
            log -V1 "---Creation Du Dossier ST sur le NAS---"

        $TestNAS = Test-Path $DESTINATION

            log -V1 "False ou TRUE : " -v2 $TestNAS 
        }

        log -V1 ""
        log -v1 "----------------------Copie du fichier ST Sur le  NAS----------------------------"
        write-host "SOURCE      : " $SOURCE
        write-host "DESTINATION : "$DESTINATION
        log -V1 "SOURCE      : " -V2 $SOURCE
        log -v1 "DESTINATION : " -v2 $DESTINATION

        $copyNasST="xcopy "+$SOURCE+" "+$DESTINATION+" /C /R /H /I /K /Y /D /E"

            
        $RapportcopyNAsST=Invoke-Expression $copyNasST
        


                #----------gestion des erreurs-------------
                if ($? -eq $false -or $LASTEXITCODE -ne "0" )
                {
                write-host " ? ! "$?
                write-host  "error : "$error
                write-host "lastexitcode : "$LASTEXITCODE
                log -v1 " ? ! " -v2 $?
                log -v1 "error : " -v2 $error
                log -v1 "lastexitcode : " -v2 $LASTEXITCODE
                $body=""
                $objet=""
                $body="Erreur copie ST vers NAS : "+$SOURCE+"     Destination : "+$DESTINATION

                $objet="!-TECHNIQUE-! Erreur copie ST vers NAS : "+ $ini.ENTREPRISE
                EnvoiMail
                $ContenuTxt="ST_COPIE_NAS=ERREUR_COPIE_ST_VERS_NAS"
                 Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
                $ContenuTxt="ST_SOURCE="+$SOURCE
                 Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
                $ContenuTxt="ST_DESTINATION="+$DESTINATION
                 Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

                $error.clear()
                }
                else 
                {
                    log -V1 ""
                    Log -V1 $RapportCopyNasST    
                    log -V1 "ST_VERS_NAS=OK"
                    $ContenuTxt="ST_COPIE_NAS=OK"
                    Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
                    $ContenuTxt="ST_SOURCE="+$SOURCE
                    Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
                    $ContenuTxt="ST_DESTINATION="+$DESTINATION
                    Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
                }                                                  

           
                        
            }# FIN $ini.Copie_ZIP_VERS_NAS -eq "OUI"
         else
         {
             log -V1 "ST_VERS_NAS=PAS_DE_COPIE"

             $ContenuTxt="ST_VERS_NAS=PAS_DE_COPIE"
             Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         }

 }#fin fonction SPECIF PROPERTIES
#-------------------------------SPECIF PROPERTIES-------------------------"

Function SpecifProperties
{

 $SOURCE=$REP_SPECIF
 $DESTINATION="'"+$ini.NAS+"SPECIF\"+"'"

        log -V1 ""        
        log -V1 "-----------------------VARIABLE Fichier SPECIF-----------------------------------"
        log -V1 $SOURCE
        log -V1 $DESTINATION
        log -V1 ""
        log -V1 "---Test Accés Dossier SPECIF Sur le  NAS---"
  if ($ini.Copie_ZIP_VERS_NAS -eq "OUI")    
    {
        $TestNAS = Test-Path $DESTINATION

        log -V1 $TestNAS

        if ($TestNAS -eq $False)
        {
        New-Item -Path $DESTINATION -ItemType Directory
                                                            
            log -V1 "-----------------Creation Du Dossier SPECIF sur le NAS--------------------------"

        $TestNAS = Test-Path $DESTINATION

            log -V1 $TestNAS
        }

        log -V1  "------------------Copie du DOSSIER SPECIF Sur le  NAS--------------------------"
        write-host "SOURCE : " $SOURCE
        write-host "DESTINATION : "$DESTINATION
         $global:body
         $global:objet
         $copyNasSPECIF="xcopy "+$SOURCE+" "+$DESTINATION+" /C /R /H /I /K /Y /D /E"


        $RapportcopyNAsSpecif=Invoke-Expression $copyNasSPECIF

        

        
        #----------gestion des erreurs-------------
        if ($? -eq $false -or $LASTEXITCODE -ne "0" )
        {
        write-host " ? ! "$?
        write-host  "error : "$error
        write-host "lastexitcode : "$LASTEXITCODE
        log -v1 " ? ! " -v2 $?
        log -v1 "error : " -v2 $error
        log -v1 "lastexitcode : " -v2 $LASTEXITCODE
        
        $body="Erreur copie SPECIF vers NAS : "+$SOURCE+"     Destination : "+$DESTINATION

        $objet="!-TECHNIQUE-! Erreur copie SPECIF vers NAS : BCKZIP : " + $ini.ENTREPRISE
        EnvoiMail
        $ContenuTxt="SPECIF_COPIE_NAS=ERREUR_COPIE_SPECIF_VERS_NAS"
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        $ContenuTxt="SPECIF_SOURCE="+$Source
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        $ContenuTxt="SPECIF_DESTINATION="+$DESTINATION
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

        $error.clear()
        }
        else
        {
        log -V1 $RapportcopyNAsSpecif  
        $ContenuTxt="SPECIF_COPIE_NAS=OK"
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        $ContenuTxt="SPECIF_SOURCE="+$Source
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        $ContenuTxt="SPECIF_DESTINATION="+$DESTINATION
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        $error.clear()
        }        
        
    }
    else
    {

            log -V1 "SPECIF_VERS_NAS=PAS_DE_COPIE"

             $ContenuTxt="SPECIF_VERS_NAS=PAS_DE_COPIE"
             Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

    }

 $SOURCE=$ini.oe+"Progress\properties\*.*"
 $DESTINATION="'"+$ini.NAS+"PROPERTIES\"+"'"
        log -V1 ""         
        log -V1 "----------------------Variables Dossier PROPERTIES-------------------------------"
        log -V1 $SOURCE
        log -V1 $DESTINATION
        log -V1 ""
        log -V1 "---------------Test Accés Dossier PROPERTIES Sur le  NAS-------------------------"
   if ($ini.Copie_ZIP_VERS_NAS -eq "OUI") 
    {
        $TestNAS = Test-Path $DESTINATION

        log -V1 $TestNAS

         if ($TestNAS -eq $False)
         {

         New-Item -Path $DESTINATION -ItemType Directory

                log -V1 "--Creation Du Dossier PROPERTIES sur le NAS --"

         $TestNAS = Test-Path $DESTINATION

                log -V1 $TestNAS
         }

        log -V1 "------------------Copie du DOSSIER PROPERTIES Sur le  NAS-----------------------"
        write-host "SOURCE : " $SOURCE
        write-host "DESTINATION : "$DESTINATION

        $copyNasPROPERTIES="xcopy "+$SOURCE+" "+$DESTINATION+" /C /R /H /I /K /Y /D /E"
        $RapportcopyNAsPROPERTIES=Invoke-Expression $copyNasPROPERTIES

        
        #----------gestion des erreurs-------------
        if ($? -eq $false -or $LASTEXITCODE -ne "0" )
        {
        write-host " ? ! "$?
        write-host  "error : "$error
        write-host "lastexitcode : "$LASTEXITCODE
        log -v1 " ? ! " -v2 $?
        log -v1 "error : " -v2 $error
        log -v1 "lastexitcode : " -v2 $LASTEXITCODE
        $body=""
        $objet=""
        $body="Erreur copie PROPERTIES vers NAS : "+$SOURCE+"     Destination : "+$DESTINATION

        $objet="!-TECHNIQUE-! Erreur copie PROPERTIES vers NAS : PROPERTIES : " + $ini.ENTREPRISE
        EnvoiMail
        $ContenuTxt="PROPERTIES_COPIE_NAS=ERREUR_COPIE_ROPERTIES_VERS_NAS"
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        $ContenuTxt="PROPERTIES_SOURCE="+$SOURCE
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt 
        $ContenuTxt="PROPERTIES_DESTINATION="+$DESTINATION
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt 
        $error.clear()
        }
        else 
        {
              log -V1 $RapportcopyNAsPROPERTIES  

        $ContenuTxt="PROPERTIES_COPIE_NAS=OK"
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        $ContenuTxt="PROPERTIES_SOURCE="+$SOURCE
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt 
        $ContenuTxt="PROPERTIES_DESTINATION="+$DESTINATION
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt 
        $error.clear()              
        }                                                 
    }
    else
    {
             log -V1 "PROPERTIES_VERS_NAS=PAS_DE_COPIE"

             $ContenuTxt="PROPERTIES_VERS_NAS=PAS_DE_COPIE"

             Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

    }

}

#-----------------------function CreationDossierLOG ----------"
function CreationDossierLOG
{

      if (Test-Path $CheminDossierLog) 

      {

      New-Item -path $chemin_fichierlog -ItemType file -Force

      Add-Content -Path $chemin_fichierlog -Value $DateLog

      }

      else 

      {

      New-Item -Path $CheminDossierLog -ItemType Directory

      New-Item -path $chemin_fichierlog -ItemType file -Force

      Add-Content -Path $chemin_fichierlog -Value $DateLog

      }

 }


 #------------------------Ajout de variable dans fichier ini-------------#
<#
if ($ini.ControleVeeam -ne "OUI" -and $ini.ControleVeeam -ne "NON")
{
write-host "ini.ControleVeeam : "$ini.ControleVeeam -ForegroundColor Yellow
		$L_Fichier_INI=get-content -Path $C_INI

		$FichierSAUVINI=$TT1+"\SAUVMAJ.ini"

		Copy-Item -Path $C_INI -Destination $FichierSAUVINI -force

        Remove-Item -Path $C_INI -Force

		New-Item -path $C_INI -ItemType File -Force

  
		foreach ($V_Fichier_INI in $L_Fichier_INI)
		{
	        if ($V_Fichier_INI.contains("ExclusionNAS=") `
                -or $V_Fichier_INI.contains("### METTRE \ à la fin EX: \\192.168.3.100\sauvegarde\   Pour exclure un dossier qui a des anciennes Sauvegardes VEEAM ET TODO") `
                -or   $V_Fichier_INI.contains("DossierSauvegarde=") `
                -or $V_Fichier_INI.contains("### METTRE \ EX: \\192.168.3.100\sauvegarde\test\ ATTTENTION uniquement si le dossier est différent de la variable NAS pour les sauvegarde VEEAM ou TODO(autre NAS ou autre dossier")
                    )

               {
                  Write-Host $V_Fichier_INI -ForegroundColor yellow
                  


                }

                else
                {
			                    if ($V_Fichier_INI.contains("### METTRE \ à la fin EX: C:\ATEGES11\") -eq $true)

			                    {
				                    Add-Content -Path $C_INI -Value $V_Fichier_INI
                                    Add-Content -Path $C_INI -Value ""
                                    add-content	-Path $C_INI -value "Copie_ZIP_VERS_NAS=OUI"
                                    Add-Content -Path $C_INI -value "### Metre oui pour copier le ZIP sur le NAS  et NON pour ne rien Faire"			
				                    Add-Content -Path $C_INI -Value ""
				                    Add-Content -Path $C_INI -Value "ControleVeeam=OUI"
				                    Add-Content -Path $C_INI -Value "### Metre oui pour vérifier les sauvegardes Veeam et NON pour ne rien verifier"
                                    Add-Content -Path $C_INI -Value ""
				                    Add-Content -Path $C_INI -Value "DESTINATION_NAS_VEEAM="
				                    Add-Content -Path $C_INI -Value "### mettre \ a la fin le chemin du dossier du NAS EX \\192.168.100.100\Sauvegarde\VEEAM" 
				                    Add-Content -Path $C_INI -Value ""
				                    Add-Content -Path $C_INI -Value "ControleTODO=OUI"
				                    Add-Content -Path $C_INI -Value "### Metre oui pour vérifier les sauvegardes TODO et non pour ne rien verifier"
                                    Add-Content -Path $C_INI -Value ""
				                    Add-Content -Path $C_INI -Value "DESTINATION_NAS_TODO="
				                    Add-Content -Path $C_INI -Value "### mettre \ a la fin le chemin du dossier du NAS EX \\192.168.100.100\Sauvegarde\TODO" 
				                    Add-Content -Path $C_INI -Value ""
				                    Add-Content -Path $C_INI -Value "LDSYSTEME="
				                    Add-Content -Path $C_INI -Value "### mettre \ a la fin le chemin du dossier sauvegarde de LDSYSTEME EX E:\LDSYSTEM\Sauvegarde\" 
                                    Add-Content -Path $C_INI -Value ""
                                    Add-Content -Path $C_INI -Value "NAS_LDSYSTEME="
				                    Add-Content -Path $C_INI -Value "### METTRE \ à la fin EX: \\192.168.3.100\sauvegarde\"
			                    }
			                    else 
			                    {
				                    Add-Content -Path $C_INI -Value $V_Fichier_INI
			                    }
                   }

		}


    $ini.clear()
    $TT1=[System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Definition)
    $C_INI=$TT1+"\maj.ini"

    $L_ini=Get-Content $C_INI 

    $ini=[ordered]@{}

    foreach ($V_INI in $L_INI)
    {

        if ( $V_INI.Contains("###") -eq $False )


            {

                $a =$V_INI.split("=")

                    if ($a[0] -ne "")
                    {
                                  
                    $ini.Add($a[0],$a[1])
                       
                    }
            }
    }
}

#>


#-------------------------récuperation rg registre-----------------------#
$clefRegistreRG="HKLM:SOFTWARE\Wow6432Node\RG Systemes\RG Supervision\agent"

$testregistre=test-path $clefRegistreRG

if ($testregistre -eq $true)
{
$idRGAgnet=get-itemproperty -path $clefRegistreRG -Name idagent
}


$InfoServeur= Get-ComputerInfo 

$PCServeur=[system.environment]::MachineName

#-----------------------------creation fichier txt FTP-------------------#

$CH_EntrepriseVersion=$TT1+"\"+$ini.Entreprise+"-"+$PCServeur+".txt"

New-Item -Path $CH_EntrepriseVersion -ItemType FILE -force

$RGSystem="RGSYSTEM="+$idRGAgnet.idagent

Add-Content -Path $CH_EntrepriseVersion -value $RGSystem

#--------------------------récupération info serveur--------------------#

$Der_Reboot=Get-CimInstance -ClassName win32_operatingsystem | select lastbootuptime

INFO_MAJ_INI


#------------------------------*BCKZIP*------------------------#

# Office 365
$Password_mail =  $ini.MDPMAIL | Convertto-SecureString -Key $PassKey
#orange
$Password_mail_orange =  $ini.MDP_MAILORANGE | Convertto-SecureString -Key $PassKey


$fdb=$ini.BASE.Split(".")
$fichierzip=$fdb[0]+".zip"
$fichierBCK=$fdb[0]+".bck"
$fichierst=$fdb[0]+".st"
$REP_SPECIF=$ini.ATEGES+"SPECIF\*.*"
$F_BCK="C:\oe11\PROGRESS\bin\probkup "+"online "+ $ini.BASE+" "+$fichierBCK
$c_7ZIP=$TT1+"\7za.exe"
$F_ZIP=$c_7ZIP+" a"+" "+$fichierzip+" "+$fichierBCK
$switchbase="BASE1"

Sauvegarde

SpecifProperties

ST

if ($ini.base2 -ne "")
{
$fdb=$ini.BASE2.Split(".")
$fichierzip=$fdb[0]+".zip"
$fichierBCK=$fdb[0]+".bck"
$fichierst=$fdb[0]+".st"
$REP_SPECIF=$ini.ATEGES+"SPECIF"
$F_BCK="C:\oe11\PROGRESS\bin\probkup "+"online "+ $ini.BASE2+" "+$fichierBCK 
$c_7ZIP=$TT1+"\7za.exe"
$F_ZIP=$c_7ZIP+" a"+" "+$fichierzip+" "+$fichierBCK

$switchbase="BASE2"
Sauvegarde

}


if ($ini.base3 -ne "")
{
       $fdb=$ini.BASE3.Split(".")
       $fichierzip=$fdb[0]+".zip"
       $fichierBCK=$fdb[0]+".bck"
       $fichierst=$fdb[0]+".st"
       $REP_SPECIF=$ini.ATEGES+"SPECIF"
       $F_BCK="C:\oe11\PROGRESS\bin\probkup "+"online "+ $ini.BASE3+" "+$fichierBCK
       $c_7ZIP=$TT1+"\7za.exe" 
       $F_ZIP=$c_7ZIP+" a"+" "+$fichierzip+" "+$fichierBCK
       $switchbase="BASE3"
       Sauvegarde

}

if ($ini.base4 -ne "")
{
       $fdb=$ini.BASE4.Split(".")
       $fichierzip=$fdb[0]+".zip"
       $fichierBCK=$fdb[0]+".bck"
       $fichierst=$fdb[0]+".st"
       $REP_SPECIF=$ini.ATEGES+"SPECIF"
       $F_BCK="C:\oe11\PROGRESS\bin\probkup "+"online "+ $ini.BASE4+" "+$fichierBCK 
       $c_7ZIP=$TT1+"\7za.exe"
       $F_ZIP=$c_7ZIP+" a"+" "+$fichierzip+" "+$fichierBCK
        $switchbase="BASE4"
       Sauvegarde

}


#------------------------FICHIER AVAMAR FTP---------------------#

$CheminDossierLog=$TT1+"\LOG\"

$chemin_fichierlog=$TT1+"\LOG\"+"AVAMAR_"+$JourLog+".txt"

CreationDossierLOG

if (test-path "C:\Program Files\avs\var\clientlogs\" )
{


    $Fichierlog = Get-ChildItem -Path "C:\Program Files\avs\var\clientlogs\"

    $CPT1=0
    foreach ( $V_Fichierlog in $Fichierlog)
    {
        if ($cpt1 -eq "1")
        {
                 if ( $V_Fichierlog.LastAccessTime -gt $DernierEcriture)
                 {
                 $DernierEcriture=$V_Fichierlog.LastAccessTime

                 $FichierName=$V_Fichierlog.Name
                 }
        }

        if ($CPT1 -eq "0" )
        {
        $DernierEcriture=$V_Fichierlog.LastAccessTime

        $FichierName=$V_Fichierlog.Name

        $cpt1=1
        }
    }

    LOG -V1 "fichier log avamar retenu : " -V2 $FichierName
    #total des espaces disques
    [DOUBLE]$total="0"


    #recuperation de la configuration
    $CheminFichier="C:\Program Files\avs\var\clientlogs\"+$FichierName
    LOG -V1 "fichier Chemin log avamar retenu : " -V2 $CheminFichier
    $ComtenuFichier=Get-Content -Path $CheminFichier
    $tableau=@(clear)
    $cpt2=0
    foreach ( $V_ComtenuFichier in $ComtenuFichier)

    {


        if ( $V_ComtenuFichier.Contains("</targetlist>") -eq $true)
        {
        $cpt2="0"
        }

            if ($cpt2 -eq 1)
            {
            $V_ComtenuFichier=$V_ComtenuFichier.Replace('"',"")
            $V_ComtenuFichier=$V_ComtenuFichier.replace('<path backup=true name=','')

            $V_ComtenuFichier=$V_ComtenuFichier.replace(' />','')
            $V_ComtenuFichier=$V_ComtenuFichier.Trim()
            $tableau+=$V_ComtenuFichier
            }

        if ( $V_ComtenuFichier.Contains("<targetlist>") -eq $true)
        {
        $cpt2="1"
        }

    }


    $tableauTailleDossier=@(clear)

    foreach ($V_tableau in $tableau)
    {

        write-host $V_tableau




        $recupinfo=(Get-ChildItem -LiteralPath $V_tableau -recurse | Measure-Object -Property Length -Sum).Sum 
        
        if ($? -eq $false -or $LASTEXITCODE -ne "0" )
        {
             $ContenuTxt="Erreur_DossierFichierAVAMAR="+$V_tableau

             Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        }
        $recupinfo3=Get-ChildItem -LiteralPath $V_tableau 

        $dossierfichier =$recupinfo3.mode

                if ($recupinfo3.mode -eq "-a----")
                {

                $type="Fichier"

                }

                if ($recupinfo3.Mode -eq "d-----")
                {
                
                $type="Dossier Racine"

                }
        $total=$total+$recupinfo

        $retour=Format-FileSize $recupinfo

        write-host "retour 1:"$retour

        $tableauTailleDossier+=$V_tableau+"@"+$retour+"@"+$type

        $recupinfo2=Get-ChildItem -LiteralPath $V_tableau

         foreach ($V_recupinfo2 in $recupinfo2)
                {
                    if ($V_recupinfo2.mode -eq "d-----")
                    {
                    write-host $V_recupinfo2.fullname -ForegroundColor Yellow

                    $recupinfoSousRep=(Get-ChildItem -LiteralPath $V_recupinfo2.FullName -recurse | Measure-Object -Property Length -Sum).Sum
            

                            if ($recupinfoSousRep -eq $null)
                            {
                            $recupinfoSousRep="0"

                            write-host $recupinfoSousRep -ForegroundColor red
                
                            }
                            else
                            {

                            $retour=Format-FileSize $recupinfoSousRep
               
                            write-host $retour

                            }
            
                    $tableauTailleDossier+=$V_recupinfo2.FullName+"@"+$retour+"@"+"Dossier"

                    }    
                }       
        
    }

    $tableauFinal=@(clear)


    foreach ($V_tableauTailleDossier in $tableauTailleDossier)
    {

    $decoupe= $V_tableauTailleDossier.split("@")

        if ($decoupe[2].Contains("Fichier") -eq $true)
        {
    
        $tableauFinal+=$decoupe[0]+";"+$decoupe[1]+";"+$decoupe[2]
    
        }
    }
    

    foreach ($V_tableauTailleDossier in $tableauTailleDossier)
    {

        $decoupe= $V_tableauTailleDossier.split("@")

        if ($decoupe[2] -eq "Dossier" -or $decoupe[2] -eq "Dossier Racine")
        {
                if ($decoupe[2] -eq "Dossier Racine")
                {

                $tableauFinal+=$decoupe[0]+";"+$decoupe[1]+";"+$decoupe[2]        
        
                }         
                  
            
                if ($decoupe[2] -eq "Dossier")
                {

                $tableauFinal+=$decoupe[0]+";"+$decoupe[1]+";"+$decoupe[2]

                }

        }
    }

        

             $V_total=Format-FileSize $total

             $tableauFinal+="Espace disque :"+";"+$V_total

             $tableauFinal+="Fichier Avamar :"+":"+$FichierName

             $tableauFinal+="DATE Fichier Avamar :"+":"+$DernierEcriture

             $FichierCSV=$TT1+"\"+$INI.ENTREPRISE+".csv"

             New-Item -Path $FichierCSV -ItemType FILE -force

             $Premiereligne = "DossierFichier;TailleArrondi;Type"

             add-content -Path $FichierCSV -value $Premiereligne

             foreach ($V_tableauFinal in $tableauFinal)
             {


             add-content -Path $FichierCSV -value $V_tableauFinal


             }

            

            $Username = $ini.EMAIL_ENVOI
            $PasswordFTP =  $ini.MDPFTP | Convertto-SecureString -Key $PassKey
            $LocalFile = $FichierCSV
            $FichierAvamarFTP="ftp://fichiers.tech-infor.fr/98-FTPBCKZIP/AVAMAR/"+$INI.ENTREPRISE+".csv"
            $RemoteFile = $FichierAvamarFTP

            LOG -v1 "Username : " -V2 $Username
            LOG -V1 "Fichier Local CSV : " -V2 $LocalFile 
            LOG -V1 "Remote Fichier : " -V2 $RemoteFile
            Write-host "Username : "$Username
            Write-host "Fichier Local CSV : " $LocalFile
            write-host "Remote Fichier : " $RemoteFile
            FTP_UPLOAD


}

# ----------------------------Verfification Fichier TODO -------------------#

$ContenuTxt="ControleTODO="+$INI.ControleTODO
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt  

$CheminDossierLog=$TT1+"\LOG\"

$chemin_fichierlog=$TT1+"\LOG\"+"TODO_VEEAM_"+$JourLog+".txt"

CreationDossierLOG

if ($ini.ControleTODO -eq "OUI")

{
    if ( $ini.DESTINATION_NAS_TODO -eq "")
    {
           $infoNASTODO = Get-ChildItem -Path $ini.NAS -Recurse -Force -Include "*.pbd"

        $ContenuTxt="DosssierTODO="+$ini.NAS

        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
    }
    else 
    {
           $infoNASTODO = Get-ChildItem -Path  $ini.DESTINATION_NAS_TODO -Recurse -Force -Include "*.pbd"   

            $ContenuTxt="DosssierTODO="+$ini.DESTINATION_NAS_TODO

            Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
    }

     $Recup_infoNASTODO=@()

    foreach ($V_infoNASTODO in $infoNASTODO)

        {
             
               $Recup_infoNASTODO+=$V_infoNASTODO     
        }        
    
        $CompteurTODO_gt7="0"

        $CompteurTODO_lt7="0"

        if ($Recup_infoNASTODO -ne "")

        {
               LOG -v1 ""       
               log -v1 "---------------------Verification TODO Sauvegarde Date---------------------------"
               write-host ""
               write-host "------Verification TODO Sauvegarde Date----------"

               foreach ( $V_Recup_infoNASTODO in $Recup_infoNASTODO)
               {

               $Jour_Ecart = $DateLog.Date - $V_Recup_infoNASTODO.LastWriteTime.date

                                                  write-host
                                                  write-host "Fichier TODO : " $V_Recup_infoNASTODO.name
                                                  write-host "Jour_Ecart :"$Jour_Ecart.Days
                                                  write-host "DateLog.Date : "$DateLog.Date
                                                  write-host "V_Recup_infoNASTODO.LastWriteTime.date : "$V_Recup_infoNASTODO.LastWriteTime.date
                                                  write-host "V_Recup_infoNASTODO.length : "$V_Recup_infoNASTODO.length
                                                  log -v1 ""
                                                  log -v1 "Fichier TODO : " -v2 $V_Recup_infoNASTODO.name
                                                  log -v1 "V_Recup_infoNASTODO.LastWriteTime.date : " -v2 $V_Recup_infoNASTODO.LastWriteTime.date
                                                  log -v1 "V_Recup_infoNASTODO.length             : " -v2 $V_Recup_infoNASTODO.length
                                                  log -v1 "DateLog.Date    : " -v2 $DateLog.Date
                                                  log -v1 "Jour_Ecart.Days : " -v2 $Jour_Ecart.days
                                          
                                          

                      if ($Jour_Ecart.Days -gt "7" -or $V_Recup_infoNASTODO.length -eq "0" )
                      {
              
                             log -v1 ""
                             log -v1 " ---Compteur gt7 = 1 pour la sauvegarde suivante---"
                                 log -v1 "Fichier TODO : " -v2 $V_Recup_infoNASTODO.name
                                 log -v1 ""
                                 $CompteurTODO_gt7 = "1"

                          }
                          if ($Jour_Ecart.Days -lt "7" )
                          {
              
                                 log -v1 ""
                                 log -v1 " ---Compteurlt7 = 1 pour la sauvegarde suivante---"
                                 log -v1 "Fichier TODO : " -v2 $V_Recup_infoNASTODO.name
                                 log -v1 ""
                                 $CompteurTODO_lt7 = "1"

                          }

                   }

            }

            if ($CompteurTODO_gt7 -eq "1" -and $CompteurTODO_lt7 -eq "0")
            {
                   $body = "Ecart de plus de 7 jours ou Taille  zero des sauvegardes TODO"
                   $Objet = "TODO Erreur Sauvegarder : "+$ini.ENTREPRISE

                   write-host "Variable pour l'envoi du mail TODO"       
                   log -v1 "---------------------Variable pour l'envoi du mail TODO--------------------------"
                   log -v1 "body  : " -v2 $body 
                   log -v1 "objet : " -v2 $Objet
                   envoimail
            $ContenuTxt="TODO_VERIFICATION=Ecart de plus de 7 jours ou Taille  zero des sauvegardes TODO"
            Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        

            }
            else
            {
                 $ContenuTxt="TODO_VERIFICATION=OK"
                Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
            }
} 
 
# ----------------------------Verfification Fichier VEEAM-------------------#

$ContenuTxt="ControleVeeam="+$INI.ControleVeeam
Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

if ($ini.ControleVeeam -eq "OUI")
{
    if ( $ini.DESTINATION_NAS_VEEAM -eq "")
    {
           $infoNASVEEAM = Get-ChildItem -Path $ini.NAS -Recurse -Force -Include ("*.vbk","*.vib")
            $ContenuTxt="DossierVEEAM="+$ini.NAS
            Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
    }
    else 
    {
           $infoNASVEEAM = Get-ChildItem -Path $ini.DESTINATION_NAS_VEEAM -Recurse -Force -Include ("*.vbk","*.vib")
            $ContenuTxt="DossierVEEAM="+$ini.DESTINATION_NAS_VEEAM
            Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
    }

    if ($infoNASVEEAM -ne $null)
    {
        
        $Recup_infoNASVEEAM=@()

        foreach ($V_infoNASVEEAM in $infoNASVEEAM)
        {

                 $Recup_infoNASVEEAM+=$V_infoNASVEEAM 

        }

       
        $compteurVEEAMgt7 ="0"
        $compteurVEEAMlt7 ="0"

        if ($Recup_infoNASVEEAM -ne "")

        {
               log -v1 ""       
               log -v1 "------------------Verification VEEAM Sauvegarde Date-----------------------------"
               write-host ""
               write-host "------Verification VEEAM Sauvegarde Date----------"

                foreach ( $V_Recup_infoNASVEEAM in $Recup_infoNASVEEAM)
               {

                      $Jour_Ecart = $DateLog.Date - $V_Recup_infoNASVEEAM.LastWriteTime.date

                      write-host
                      write-host "FICHIER VEEAM : "$V_Recup_infoNASVEEAM.name
                      write-host "Jour_Ecart.Days :"$Jour_Ecart.days
                      write-host "DateLog.Date : "$DateLog.Date
                      write-host "V_Recup_infoNASVEEAM.LastWriteTime.date : "$V_Recup_infoNASVEEAM.LastWriteTime.date
                      write-host "V_Recup_infoNASVEEAM.length : $V_Recup_infoNASVEEAM.length"
                      LOG -v1 ""
                      log -v1 "FICHIER VEEAM : " -v2 $V_Recup_infoNASVEEAM.name
                      log -v1 "V_Recup_infoNASVEEAM.LastWriteTime.date : " -v2 $V_Recup_infoNASVEEAM.LastWriteTime.date
                      log -v1 "V_Recup_infoNASVEEAM.length             : " -v2 $V_Recup_infoNASVEEAM.length
                      log -v1 "DateLog.Date    : " -v2 $DateLog.Date
                      log -v1 "Jour_Ecart.Days : " -v2 $Jour_Ecart.days
                                                 
                                                 

                      if ($Jour_Ecart.Days -gt "7" -or $V_Recup_infoNASVEEAM.length -eq "0" )
                      {

                             log -v1 ""
                             log -v1 " ---Compteurgt7 = 1 pour la sauvegarde suivante---"
                             log -v1 "Fichier VEEAM : " -v2 $V_Recup_infoNASVEEAM.name
                             log -v1 ""
                             $compteurVEEAMgt7 = "1"
                             write-host "dans la boucle gt 1 " -ForegroundColor Yellow
              

                      }

                      if ($Jour_Ecart.Days -lt "7" )
                      {

                             log -v1 ""
                             log -v1 " ---Compteurlt7 = 1 pour la sauvegarde suivante---"
                             log -v1 "Fichier VEEAM : " -v2 $V_Recup_infoNASVEEAM.name
                             log -v1 ""
                             $compteurVEEAMlt7 = "1"
                             write-host "dans la boucle lt 1 " -ForegroundColor Yellow
              

                      }

               }

        }

        write-host "compteurVEEAMgt7 : "$compteurVEEAMgt7 -ForegroundColor Yellow
        write-host "compteurVEEAMlt7 :"$compteurVEEAMlt7 -ForegroundColor Yellow

            if ($compteurVEEAMgt7 -eq "1"-and $compteurVEEAMlt7 -eq "0")
            {
                    $body = "Ecart de plus de 7 jours ou Taille  zero des sauvegardes VEEAM"
                    $Objet = "VEEAM Erreur Sauvegarder : "+$ini.ENTREPRISE

                   write-host "------------Variable pour l'envoi du mail VEEAM--------------"       
                   log -v1 "--------------------Variable pour l'envoi du mail VEEAM--------------------------"
                   log -v1 "body  : " -v2 $body 
                   log -v1 "objet : " -v2 $Objet

                    envoimail
             
                $ContenuTxt="VEEAM_VERIFICATION=Ecart de plus de 7 jours ou Taille  zero des sauvegardes VEEAM"
                Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
        
            }
            else
            {

             $ContenuTxt="VEEAM_VERIFICATION=Ecart de plus de 7 jours ou Taille  zero des sauvegardes VEEAM"
                Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

            }
    }
}
#---------------Connexion FTP RECUPERATION Fichier version------#

$CheminDossierLog=$TT1+"\LOG\"

if (Test-Path $CheminDossierLog)
{



$chemin_fichierlog=$TT1+"\LOG\"+"MAJ_"+$JourLog+".txt"

New-Item -path $chemin_fichierlog -ItemType file -Force

Add-Content -Path $chemin_fichierlog -Value $DateLog

}
else 
{

New-Item -Path $CheminDossierLog -ItemType Directory

$chemin_fichierlog=$TT1+"\LOG\"+"MAJ_"+$JourLog+".txt"

New-Item -path $chemin_fichierlog -ItemType file -Force

Add-Content -Path $chemin_fichierlog -Value $DateLog

}

$CheminFichierVersionFTP=$TT1+"\versionftp.txt"


$Username = $ini.EMAIL_ENVOI
$PasswordFTP =  $ini.MDPFTP | Convertto-SecureString -Key $PassKey
$LocalFile = $CheminFichierVersionFTP
$RemoteFile = "ftp://fichiers.tech-infor.fr/98-FTPBCKZIP/versionftp.txt"
LOG -V1 "---------------------Telechargement fichier version ftp -------------------------"
LOG -v1 "Utilisateur   : " -v2 $Username 
LOG -v1 "Fichier Local : " -V2 $LocalFile
LOG -v1 "Remote File   : " -V2 $RemoteFile

FTPTelecharger

$testChemin=Test-Path $LocalFile
LOG -V1 "testChemin FTp : "$testChemin
LOG -V1 ""
$InfoFichierVersionFTP = Get-ChildItem $LocalFile

if ($testChemin -eq $False -or $InfoFichierVersionFTP.LastWriteTime.Date -ne $DateLog.Date -or $InfoFichierVersionFTP.Length -eq "0")
{

write-host " ----------erreur de sur le fichier Version-----------"
$body="Fichier versionFTP ne s'est pas telecharger ou la date du fichier versionftp est differente de la date du jour ou taille à zero " 
$objet="Telechargement fichier VERSIONFTP : "+$ini.ENTREPRISE
LOG -V1 "----------------------erreur de sur le fichier Version---------------------------"
LOG -V1 "Body : "$body
LOG -V1 "Objet : "$objet
LOG -V1 "Date Fichier Version FTP : "$InfoFichierVersionFTP.LastWriteTime.Date
LOG -V1 ""

envoimail

}

$l_FichierVersion= $TT1+"\version.txt"

$FichierVersion=get-content -Path $l_FichierVersion

foreach ( $V_FichierVersion in $FichierVersion)

{
$R_contains=$V_FichierVersion.Contains( "version")

    if ( $R_contains -eq $true)
    {
    
    $S_FichierVersion=$V_FichierVersion.split("=")
    [INT]$versionServeur=$S_FichierVersion[1]
    write-host "Version fichier version serveur "
    log -v1 "Version fichier version serveur "
    log -v1 "version.txt serveur : " -v2 $versionServeur
    log -V1 ""

    }
}

$FichierVersionFTP=get-content -Path $CheminFichierVersionFTP

foreach ( $V_FichierVersionFTP in $FichierVersionFTP)

{

    $R_containsFTP=$V_FichierVersionFTP.Contains( "version")

    if ( $R_containsFTP -eq $true)
    {
    write-host "dans la boucle fichier version FTP"
    $S_FichierVersionFTP=$V_FichierVersionFTP.split("=")
    [INT]$versionServeurFTP=$S_FichierVersionFTP[1]
    log -v1 "dans la boucle fichier version FTP "
    log -v1 "Version Fichier FTP : " -v2 $versionServeurFTP
    log -V1 ""

    }
}
[INT]$CPTE_TelechargementPS1="0"

$cheminFichierTemp=$TT1+"\TEMP\"

if (Test-Path $cheminFichierTemp)
{
write-host "le dossier TEMP existe : "

log -V1 "le dossier TEMP existe : " -v2 $cheminFichierTemp

}

else
{
New-Item -Path $cheminFichierTemp -ItemType Directory
log -V1 "le dossier TEMP est crée : " -v2 $cheminFichierTemp
}

if ($versionServeurFTP -gt $versionServeur)
{
       $CPTE_TelechargementPS1="1"
       log -V1 "------------------------Telechargement des fichier-------------------------------"
       $LocalFile = $cheminFichierTemp+"BCKZIP.ps1"
       $RemoteFile = "ftp://fichiers.tech-infor.fr/98-FTPBCKZIP/bckZIP.ps1"
       FTPTelecharger
       Move-Item $LocalFile $TT1 -force
       log -V1 "LocalFile : " -v2 $LocalFile
       log -v1 "RemoteFile :" -v2 $RemoteFile
       log -V1 ""
       $LocalFile = $cheminFichierTemp+"COMPTA.ps1"
       $RemoteFile = "ftp://fichiers.tech-infor.fr/98-FTPBCKZIP/COMPTA.ps1"
       FTPTelecharger
       Move-Item $LocalFile $TT1 -Force
       log -v1 "LocalFile : " -v2 $LocalFile
       log -v1 "RemoteFile :" -v2 $RemoteFile
       log -V1 ""
       $LocalFile = $cheminFichierTemp+"INSTALL.ps1"
       $RemoteFile = "ftp://fichiers.tech-infor.fr/98-FTPBCKZIP/INSTALL.ps1"
       FTPTelecharger
       Move-Item $LocalFile $TT1 -Force
       log -v1 "LocalFile : " -v2 $LocalFile
       log -v1 "RemoteFile :" -v2 $RemoteFile
       log -V1 ""
       $R_Suppression=Remove-Item -Path $l_FichierVersion -Force
       log -v1 "suppression fichier version serveur" -v2 $R_Suppression
       log -V1 ""
       $C_Creation=New-Item -Path $l_FichierVersion -ItemType file -Force
       log -v1 "creation fichier version serveur" -v2 $C_Creation
       log -V1 ""
       $Valeur = "version="+$versionServeurFTP

       Add-Content -Path $l_FichierVersion -Value $Valeur
       log -v1 "ajout de la valeur dans le fichier version serveur" 
       log -v1 "version.txt FTP : " -v2 $versionServeurFTP
       log -v1 "version Serveur : " -v2 $Valeur
}


if ($CPTE_TelechargementPS1 -eq "1")
{
$chemin_fichierlogPieceJoint=$TT1+"\FichierJoint.txt"
new-item -Path $chemin_fichierlogPieceJoint -Force -ItemType file
$contennu_fichierlogPieceJoint=get-content -path $chemin_fichierlog
Add-Content -path $chemin_fichierlogPieceJoint -Value $contennu_fichierlogPieceJoint
$chemin_FichierJoint=$chemin_fichierlogPieceJoint
$body="Download Fichier .ps1"

$objet="DOWNLOAD Fichier .ps1 : "+ $ini.ENTREPRISE
EnvoiMailPieceJointe

}

        if ($CPTE_TelechargementPS1 -eq "0")
        {
        $body=@"
        PAS de Telechargement Fichier .ps1
        Version_Serveur = $versionServeur
        VersionFTP = $versionServeurFTP
"@


        $objet="PAS Telechargement Fichier .ps1 : "+ $ini.ENTREPRISE

        EnvoiMail
        }


#-------------Recuperation version sur les fichier PS1------------------#
LOG -V1 ""

LOG -V1 "-------------Recuperation version sur les fichier PS1------------------"
LOG -V1 ""
$CH_BCKZIP=$TT1+"\BCKZIP.ps1"
LOG -V1 "Chemin fichier BCKZIP = " -V2 $CH_BCKZIP 
$OuvertureFichierBCKZIP=get-content $CH_BCKZIP

foreach ($V_OuvertureFichierBCKZIP in $OuvertureFichierBCKZIP)
{
    if ($V_OuvertureFichierBCKZIP.contains("VerFichierBCKZIP") -eq $true)
    {
    $Split_BCKZIP=$V_OuvertureFichierBCKZIP.split("=")
    $Ver_BCKZIP=$Split_BCKZIP[1]
    LOG -V1 "Version BCKZIP = " -V2 $Ver_BCKZIP 
 
    write-host "Ver_BCKZIP : " $Ver_BCKZIP
    }
}

$CH_COMPTA=$TT1+"\COMPTA.ps1"

LOG -V1 "Chemin Fichier COMPTA = " -V2 $CH_COMPTA 
$OuvertureFichierCOMPTA=get-content $CH_COMPTA
foreach ($V_OuvertureFichierCOMPTA in $OuvertureFichierCOMPTA)
{
    if ($V_OuvertureFichierCOMPTA.contains("VerFichierCompta") -eq $true)
    {
    $Split_COMPTA=$V_OuvertureFichierCOMPTA.split("=")
    $Ver_COMPTA=$Split_COMPTA[1]
    LOG -V1 "Version COMPTA : " -V2 $Ver_COMPTA 

    write-host "Ver_COMPTA : "$Ver_COMPTA
    }
}

$CH_INSTALL=$TT1+"\INSTALL.ps1"
LOG -V1 "Chemin Fichier INSTALL : " -V2 $CH_INSTALL 
$OuvertureFichierINSTALL=get-content $CH_INSTALL
foreach ($V_OuvertureFichierINSTALL in $OuvertureFichierINSTALL)
{
    if ($V_OuvertureFichierINSTALL.contains("VerFichierINSTALL") -eq $true)
    {
    $Split_INSTALL=$V_OuvertureFichierINSTALL.split("=")
    $Ver_INSTALL=$Split_INSTALL[1]
    LOG -V1 "Version INSTALL =" -V2 $Ver_INSTALL
    write-host "Ver_INSTALL : " $Ver_INSTALL
    }
}





#--------ajout de la version des fichiers PS1-------------------------#


$VAL_BCKZIP="Version_BCKZIP=$Ver_BCKZIP"
Add-Content -Path $CH_EntrepriseVersion -Value $VAL_BCKZIP
$VAL_COMPTA="Version_COMPTA=$Ver_COMPTA"
Add-Content -Path $CH_EntrepriseVersion -Value $VAL_COMPTA
$VAL_INSTALL="Version_INSTALL=$Ver_INSTALL"
Add-Content -Path $CH_EntrepriseVersion -Value $VAL_INSTALL


#----------------------COPIE FICHIER CLIENT-----------------------------#
$CheminDossierLog=$TT1+"\LOG\"

if (Test-Path $CheminDossierLog)
{



$chemin_fichierlog=$TT1+"\LOG\"+"COPIES_FICHIERS_"+$JourLog+".txt"

New-Item -path $chemin_fichierlog -ItemType FILE -Force

Add-Content -Path $chemin_fichierlog -Value $DateLog

}
else 
{

New-Item -Path $CheminDossierLog -ItemType Directory

$chemin_fichierlog=$TT1+"\LOG\"+"COPIES_FICHIERS_"+$JourLog+".txt"

New-Item -path $chemin_fichierlog -ItemType file -Force

Add-Content -Path $chemin_fichierlog -Value $DateLog

}

if ($NASClients -eq "")
{
       $NasDossierClient = $ini.NAS
}

else
{
       $NasDossierClient = $ini.NASClients
}

LOG -v1 "NAS : " -V2 $NasDossierClient


if ($ini.DossiersClients -ne "")

{
$DossierFichier=$ini.DossiersClients.split(";")

$DESTINATION="'"+$NasDossierClient+"COPIES_FICHIERS_CLIENT\"+"'"

$retour =Test-Path $DESTINATION
       if( $retour -eq $False )
       {
       
       new-item -Path $DESTINATION -ItemType Directory

       }

       foreach ($V_DossierFichier in $DossierFichier)
       {
       $source=$V_DossierFichier+"*.*"
       

       LOG -V1 "----------------------Copie du dossier------------------"
       LOG -V1 "SOURCE : " -V2 $SOURCE
       LOG -V1 "DESTINATION : " -V2 $DESTINATION
       LOG -v1 ""
       write-host "SOURCE : " $SOURCE
       write-host "DESTINATION : "$DESTINATION
        $ContenuTxt="DOSSIER_CLIENTS="+$INI.DossiersClients
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

        $ContenuTxt="DOSSIER_CLIENTS_NAS="+$INI.NASClients
        Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
       $copyNasFichierClient="xcopy "+$SOURCE+" "+$DESTINATION+" /C /R /H /I /K /Y /D /E"
       $RapportcopyNAsFichierClient=Invoke-Expression $copyNasFichierClient
        #----------gestion des erreurs-------------
        if ($? -eq $false -or $LASTEXITCODE -ne "0" )
        {
        write-host " ? ! "$?
        write-host  "error : "$error
        write-host "lastexitcode : "$LASTEXITCODE
        log -v1 " ? ! " -v2 $?
        log -v1 "error : " -v2 $error
        log -v1 "lastexitcode : " -v2 $LASTEXITCODE
        
        $body="Erreur copie DOSSIERS CLIENT vers NAS : "+$SOURCE+"     Destination : "+$DESTINATION

        $objet="!-TECHNIQUE-! DOSSIERS CLIENT : Erreur copie DOSSIERS CLIENT vers NAS : "+ $ini.ENTREPRISE
        EnvoiMail

         $ContenuTxt="DOSSIERS CLIENT=Erreur copie DOSSIERS CLIENT vers NAS"
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="DOSSIERS CLIENT_SOURCE="+$SOURCE
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="DOSSIERS CLIENT_DESTINATION="+$DESTINATION
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

        $error.clear()
        }
        else
        {
              log -V1 ""
              log -V1 $RapportCopyNasZIP

         $ContenuTxt="DOSSIERS CLIENT=COPIE_OK"
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="DOSSIERS CLIENT_SOURCE="+$SOURCE
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="DOSSIERS CLIENT_DESTINATION="+$DESTINATION
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt                                                  
             
        }
       LOG -V1 $RapportcopyNAsFichierClient
       write-host $RapportcopyNAsFichierClient

       }
}


#----------------ldsystem sauvegarde------------"


$INI.LDSYSTEME
$INI.NAS_LDSYSTEME

$CheminDossierLog=$TT1+"\LOG\"
$chemin_fichierlog=$TT1+"\LOG\"+"LDSYSTEM_"+$JourLog+".txt"
if (Test-Path $CheminDossierLog)
{



$chemin_fichierlog=$TT1+"\LOG\"+"LDSYSTEM_"+$JourLog+".txt"

New-Item -path $chemin_fichierlog -ItemType FILE -Force

Add-Content -Path $chemin_fichierlog -Value $DateLog

}
else 
{

New-Item -Path $CheminDossierLog -ItemType Directory

$chemin_fichierlog=$TT1+"\LOG\"+"LDSYSTEM_"+$JourLog+".txt"

New-Item -path $chemin_fichierlog -ItemType file -Force

Add-Content -Path $chemin_fichierlog -Value $DateLog

}





if ( $INI.LDSYSTEME -ne "")
{


$source=$INI.LDSYSTEME
$DESTINATION ="'"+$INI.NAS_LDSYSTEME+"\"+$JourLog+"\"+"'"

  
    log -V1 "-------------copie LDSYSTEM--------"
    log -V1 $source
    log -V1 $DESTINATION

$TestNAS= Test-Path $DESTINATION

         if ($TestNAS -eq $False)
         {
                New-Item -Path $DESTINATION -ItemType Directory
                log -V1 ""
                log -V1 "---------------------Creation Du Dossier NAS_LDSYSTEM\JOURS sur le NAS-------------------"

                $TestNAS = Test-Path $DESTINATION ### refait un test du fichier de destination
                log -V1 $TestNAS
         }

$copyLDSyteme="xcopy "+$SOURCE+" "+$DESTINATION+" /C /R /H /I /K /Y /D"

    

    if ($? -eq $false -or $LASTEXITCODE -ne "0" )
        {
        write-host " ? ! "$?
        write-host  "error : "$error
        write-host "lastexitcode : "$LASTEXITCODE
        log -v1 " ? ! " -v2 $?
        log -v1 "error : " -v2 $error
        log -v1 "lastexitcode : " -v2 $LASTEXITCODE
        
        $body="Erreur copie DOSSIERS LDSYSTEME vers NAS : "+$SOURCE+"     Destination : "+$DESTINATION

        $objet="!-TECHNIQUE-! DOSSIERS LDSYTEME : Erreur copie DOSSIERS LDSYTEME vers NAS : "+ $ini.ENTREPRISE
        EnvoiMail

         $ContenuTxt="DOSSIERS LDSYTEME=Erreur copie DOSSIERS LDSYTEME vers NAS"
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="DOSSIERS LDSYTEME_SOURCE="+$SOURCE
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="DOSSIERS LDSYTEME_DESTINATION="+$DESTINATION
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

        $error.clear()
        }
        else
        {
              log -V1 ""
              log -V1 $RapportCopyNasZIP

         $ContenuTxt="DOSSIERS LDSYTEME=OK"
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="DOSSIERS LDSYTEME_SOURCE="+$SOURCE
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt
         $ContenuTxt="DOSSIERS LDSYTEME_DESTINATION="+$DESTINATION
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt                                                  
             
        }



}

LOG -V1 $copyLDSyteme

#------------------Verification BCK sur le NAS------------------#

if ($ini.NAS -ne "")
{
$JOUR_NAS_BCK="LUNDI"
$cheminBCKZIP=$ini.NAS+"\BCK\"+$JOUR_NAS_BCK+"\"
Verfication_BCK_NAS

$JOUR_NAS_BCK="MARDI"
$cheminBCKZIP=$ini.NAS+"\BCK\"+$JOUR_NAS_BCK+"\"
Verfication_BCK_NAS

$JOUR_NAS_BCK="MERCREDI"
$cheminBCKZIP=$ini.NAS+"\BCK\"+$JOUR_NAS_BCK+"\"
Verfication_BCK_NAS

$JOUR_NAS_BCK="JEUDI"
$cheminBCKZIP=$ini.NAS+"\BCK\"+$JOUR_NAS_BCK+"\"
Verfication_BCK_NAS

$JOUR_NAS_BCK="VENDREDI"
$cheminBCKZIP=$ini.NAS+"\BCK\"+$JOUR_NAS_BCK+"\"
Verfication_BCK_NAS

$JOUR_NAS_BCK="SAMEDI"
$cheminBCKZIP=$ini.NAS+"\BCK\"+$JOUR_NAS_BCK+"\"
Verfication_BCK_NAS

$JOUR_NAS_BCK="DIMANCHE"
$cheminBCKZIP=$ini.NAS+"\BCK\"+$JOUR_NAS_BCK+"\"
Verfication_BCK_NAS
}
$cheminFichierComptaTXT=$TT1+"\"+"COMPTA.txt"

    if (Test-Path  $cheminFichierComptaTXT)
{
    $variableComptaTXT=Get-Content  -path $cheminFichierComptaTXT

    foreach ($V_variableComptaTXT in $variableComptaTXT)
    {

    Add-Content -Path $CH_EntrepriseVersion -value $V_variableComptaTXT

    }

}

    
#---------------------Erreur dans le fichier bckziplog.txt------------#

$Log_Tache=$TT1+"\"+"bckziplog.txt"
$RetourLog_Tache = Select-String -Path $Log_Tache -Pattern 'bckzip.ps1'

    if ($RetourLog_Tache -ne $NULL)
    {
         $ContenuTxt='Log_Tache_Planifiee=ERREUR'
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

    }
    else
    {
         $ContenuTxt= 'Log_Tache_Planifiee=OK'
         Add-Content -Path $CH_EntrepriseVersion -value $ContenuTxt

    }

#--------------------Envoi du fichier @-@.txt--------------------------#

$chemin_fichierlog=$TT1+"\LOG\"+"ENVOI_TXT_"+$JourLog+".txt"

CreationDossierLOG

LOG -V1 "Envoi du fichier @-@.txt"

            $Username = $ini.EMAIL_ENVOI
            $PasswordFTP =  $ini.MDPFTP | Convertto-SecureString -Key $PassKey
            $LocalFile = $CH_EntrepriseVersion
            LOG -V1 "fichier local : " -V2 $LocalFile 
            $FichierAvamarFTP="ftp://fichiers.tech-infor.fr/98-FTPBCKZIP/FTP/"+$INI.ENTREPRISE+"@-@"+$PCServeur+".txt"
            $RemoteFile = $FichierAvamarFTP
            LOG -V1 "Fichier FTP RemoteFile : " -V2 $RemoteFile 

            FTP_UPLOAD

$VerFichierBCKZIP=23

    
    


